;**********************************************************
;*
;* GLOBAL DEFINES
;*
;**********************************************************
;*
;* DEBUG OPTIONS
;*
;DEBUG 	=	1
;DEBUG_BREAK	=	1
;DEBUG_DUMP	=	1
;DEBUG_TIMER	=	1
;DEBUG_MEMMGR	=	1
;DEBUG_LOCK	=	1
;DEBUG_LOAD	=	1
;DEBUG_INVOKE	=	1
;DEBUG_INTERP	=	1
;DEBUG_THREAD	=	1
;DEBUG_FINALIZE	=	1
;DEBUG_EXCEPT	=	1
;*
;* HANDY MACROS
;*
.DEFINE	EQU	=
.IFDEF	DEBUG
.MACRO	PERR	MSG
	.IMPORT	PUTSLN
	JSR	PUTSLN
	.ASCIIZ	MSG
.ENDMACRO
.ELSE
.MACRO	PERR	MSG
.ENDMACRO
.ENDIF
.MACRO	PSTR	MSG
	.IMPORT	PUTS
	JSR	PUTS
	.ASCIIZ	MSG
.ENDMACRO
.MACRO	PSTRLN	MSG
	.IMPORT	PUTSLN
	JSR	PUTSLN
	.ASCIIZ	MSG
.ENDMACRO
;
;**********************************************************
;*
;* SYSTEM LIMITS AND OPTIONS
;*
;**********************************************************
;
MAX_THREADS	EQU	4	; MAX THREADS ALLOWED
FLOATING_POINT	EQU	1	; SINGLE PRECISION FLOATING POINT OPERATIONS
;IDLE_GC	EQU	1	; DO GC DURING IDLE LOOP
;SWAPPING	EQU	1	; MEMORY HANDLE SWAPPING TO DISK
;BIGMEM	EQU	1	; 128K MEMORY SUPPORT FOR //C AND //E
;
;**********************************************************
;*
;* ZERO PAGE LOCATIONS
;*
;**********************************************************
;
OPJMP	EQU	$02
OPCNT	EQU	$04
;*
;* LOWERCASE MASKS FOR CONSOLE I/O
;*
LCOUT_MASK	EQU	$06
LCIN_MASK	EQU	$07
;*
;* THREAD/BYTECODE INTERPRETER ZERO PAGE LOCATIONS
;*
ZP_THREAD_STATE EQU	$0E
ZP_THREAD_SIZE	EQU	$12
EXECFLAGS	EQU	$0E
IEXECCLASS	EQU	$0F	; INDEX TO CURRENT CLASS
HEXECFRAME	EQU	$10	; HANDLE TO CURRENT FRAME
EXECPC	EQU	$12	; PROGRAM COUNTER
EXECCODEPTR	EQU	$14	; POINTER TO CODE SEGMENT
BPT	EQU	$16	; BASE TYPE POINTER
BP0	EQU	$18	; BASE BYTE0 POINTER
BP1	EQU	$1A	; BASE BYTE1 POINTER
BP2	EQU	$1C	; BASE BYTE2 POINTER
BP3	EQU	$1E	; BASE BYTE3 POINTER
;*
;* CODE MANAGER ZERO PAGE LOCATIONS
;*
CODEBLKPTR	EQU	$56
CODECOPYPTR	EQU	$58
;*
;* OPCODE INTERPRETER ZERO PAGE LOCATIONS
;*
ICONST	EQU	$60
PCINC	EQU	$60
CONSTPTR	EQU	$62
ARRAYPTR	EQU	$62
FIELDPTR	EQU	$62
ARRAYHNDL	EQU	$62
TARGETCLASS	EQU	$64
TARGETOBJ	EQU	$66
TARGETSIZE	EQU	$68
TARGETOFFSET	EQU	$68
TARGETTYPE	EQU	$6A
TARGETDEPTH	EQU	$6E
ADEPTH	EQU	$6F
;*
;* SWITCH OPCODE ZERO PAGE LOCATIONS
;*
TABLEIDX	EQU	$64
TABLEPTR	EQU	$6A
MATCHPTR	EQU	$6C
MATCHCNT	EQU	$6E
;*
;* INT MATH ZERO PAGE LOCATIONS
;*
MULTPLR	EQU	$60
MULTPLND	EQU	$64
PROD	EQU	$68
MULIDX	EQU	$6C
MULSIGN	EQU	$6D
DVDND	EQU	$60
DVSR	EQU	$64
REMNDR	EQU	$68
DVSIGN	EQU	$6C
;*
;* FLOATING POINT MATH ZERO PAGE LOCATIONS
;*
FP1MAN0	EQU	$60
FP1MAN1	EQU	$61
FP1MAN2	EQU	$62
FP1MAN3	EQU	$63
FP1SGN	EQU	$63
FP1EXP	EQU	$64
FP2MAN0	EQU	$65
FP2MAN1	EQU	$66
FP2MAN2	EQU	$67
FP2MAN3	EQU	$68
FP2SGN	EQU	$68
FP2EXP	EQU	$69
FPMAN0	EQU	$6A
FPMAN1	EQU	$6B
FPMAN2	EQU	$6C
FPMAN3	EQU	$6D
FPSGN	EQU	$6E
FPEXP	EQU	$6F
;*
;* FRAME MANAGER ZERO PAGE LOCATIONS
;*
RETURN_REF	EQU	$60
EXECFRAMEPTR	EQU	$62
LINKFRAMEPTR	EQU	$64
EXCEPTPTR	EQU	$66
STACKPOS	EQU	$66
EXCEPTCNT	EQU	$68
STACKPOPPED	EQU	$68
VARCNT	EQU	$69
SCANPOS	EQU	$6A
SCANPTR	EQU	$6B
;*
;* NATIVE METHOD ZERO PAGE LOCATIONS
;*
NATIVECODEPTR	EQU	$A0
HMETHODCODE	EQU	$A2
NATIVE_00	EQU	$A0
NATIVE_01	EQU	$A1
NATIVE_02	EQU	$A2
NATIVE_03	EQU	$A3
NATIVE_04	EQU	$A4
NATIVE_05	EQU	$A5
NATIVE_06	EQU	$A6
NATIVE_07	EQU	$A7
NATIVE_08	EQU	$A8
NATIVE_09	EQU	$A9
NATIVE_0A	EQU	$AA
NATIVE_0B	EQU	$AB
NATIVE_0C	EQU	$AC
NATIVE_0D	EQU	$AD
NATIVE_0E	EQU	$AE
NATIVE_0F	EQU	$AF
;*
;* SYSTEM CLASS ZERO PAGE LOCATIONS
;*
CCLASSPTR	EQU	$B0
CCLASSCNT	EQU	$B2
CCLASSINDEX	EQU	$B4
CCLASSNAME	EQU	$B6
CCLASSDESC	EQU	$B8
CCTBLPTR	EQU	$BA
CCINSTPTR	EQU	$BC
CCINST	EQU	$BE
;*
;* CLASS LOADER/FRAME HANDLER ZERO PAGE LOCATIONS
;*
METHODPTR	EQU	$C0
CLBUFFPTR	EQU	$C0
CLBUFFOFST	EQU	$C2
CLBUFFPAGE	EQU	$C3
SUPERPTR	EQU	$C2
CLASSLDPTR	EQU	$C4
LDPTR	EQU	$C6
LDCNT	EQU	$C8
ACNT	EQU	$CA
CLDPTR	EQU	$CC
CCNT	EQU	$CE
VCNT	EQU	$CE
;*
;* STRING POOL ZERO PAGE LOCATIONS
;*
STRPTR	EQU	$D0
HSTR	EQU	$D2
STRMATCHPTR	EQU	$D4
STRHASH	EQU	$D6
HSTRNEXT	EQU	$D8
REFCNT	EQU	$DA
;*
;* UTILITIES ZERO PAGE LOCATIONS
;*
SRCADDR	EQU	$DC
DSTADDR	EQU	$DE
;*
;* GARBAGE COLLECTION ZERO PAGE LOCATIONS
;*
GCHNDL	EQU	$E0
GCMPTR	EQU	$E2
GCMEND	EQU	$E4
GCTMP	EQU	$E6
GCBEST	EQU	$E8
GCNEIGHBOR	EQU	$EA
GCNEEDED	EQU	$EC
;*
;* FINALIZER ZERO PAGE LOCATIONS
;*
FINPTR	EQU	$EE
;*
;* MEMORY MANAGER ZERO PAGE LOCATIONS
;*
HUNUSED	EQU	$F0
HFREE	EQU	$F2
HNDL	EQU	$F4
MPTR	EQU	$F6
MLEN	EQU	$F8
MEND	EQU	$FA
TMP	EQU	$FC
TMPTR	EQU	$FC
HBEST	EQU	$FE
;
;**********************************************************
;*
;* EXTERNAL LINKEAGE JUMP TABLE
;*
;**********************************************************
;
LINK_TABLE	EQU	$0300
LINK_YIELD	EQU	LINK_TABLE+$00
LINK_LOCKENTER	EQU	LINK_TABLE+$02
LINK_LOCKEXIT	EQU	LINK_TABLE+$04
;
LINK_HMEMPTR	EQU	LINK_TABLE+$06
LINK_HMEMALLOC	EQU	LINK_TABLE+$08
LINK_HMEMALLOCFIXED EQU	LINK_TABLE+$0A
LINK_HMEMFREE	EQU	LINK_TABLE+$0C
LINK_HMEMLOCK	EQU	LINK_TABLE+$0E
LINK_HMEMUNLOCK	EQU	LINK_TABLE+$10
;
LINK_THREADNEW	EQU	LINK_TABLE+$12
LINK_THREADPUSH	EQU	LINK_TABLE+$14
LINK_THREADSTART EQU	LINK_TABLE+$16
LINK_THREADEXIT	EQU	LINK_TABLE+$18
LINK_THREADKILL	EQU	LINK_TABLE+$1A
LINK_THREADGETCURRENT EQU	LINK_TABLE+$1C
LINK_THREADSETTIMEOUTL EQU	LINK_TABLE+$1E
LINK_THREADSETTIMEOUTH EQU	LINK_TABLE+$20
LINK_THREADNOTIMEOUT EQU	LINK_TABLE+$22
LINK_THREADSETSTATE EQU	LINK_TABLE+$24
LINK_THREADGETSTATE EQU	LINK_TABLE+$26
LINK_THREADSETPRIORITY EQU	LINK_TABLE+$28
LINK_THREADGETPRIORITY EQU	LINK_TABLE+$2A
LINK_THREADSETCLASS EQU	LINK_TABLE+$2C
LINK_THREADSETREF EQU	LINK_TABLE+$2E
LINK_THREADGETCLASS EQU	LINK_TABLE+$30
LINK_THREADGETREF EQU	LINK_TABLE+$32
LINK_THREADWAITIO EQU	LINK_TABLE+$34
LINK_THREADNOTIFYIO EQU	LINK_TABLE+$36
LINK_SYSTEMTIC	EQU	LINK_TABLE+$38
LINK_GETTICL	EQU	LINK_TABLE+$3A
LINK_GETTICH	EQU	LINK_TABLE+$3C
;
LINK_MEMSRC	EQU	LINK_TABLE+$3E
LINK_MEMDST	EQU	LINK_TABLE+$40
LINK_MEMCPY	EQU	LINK_TABLE+$42
LINK_MEMCLR	EQU	LINK_TABLE+$44
;
LINK_HSTRADD	EQU	LINK_TABLE+$46
LINK_HSTRDEL	EQU	LINK_TABLE+$48
;
;LINK_SLOTIRQ	EQU	LINK_TABLE+$4A
;LINK_HWTIMER	EQU	LINK_TABLE+$4C
;
;LINK_KBREAD	EQU	LINK_TABLE+$4E
LINK_SCRPRT	EQU	LINK_TABLE+$50
LINK_SCRPRTLN	EQU	LINK_TABLE+$52
;
LINK_PRODOS	EQU	LINK_TABLE+$54
;
LINK_HMEMREFINC	EQU	LINK_TABLE+$56
LINK_HMEMREFDEC	EQU	LINK_TABLE+$58
;
LINK_MEMSET	EQU	LINK_TABLE+$5A
;
;LINK_COUT	EQU	LINK_TABLE+$5C
;
LINK_CLASSLOAD	EQU	LINK_TABLE+$62
;
LINK_GC	EQU	LINK_TABLE+$64
LINK_FINALIZE	EQU	LINK_TABLE+$66
;
LINK_DEVREAD	EQU	LINK_TABLE+$70
LINK_DEVREAD1	EQU	LINK_TABLE+$72
LINK_DEVREAD2	EQU	LINK_TABLE+$74
LINK_DEVREAD3	EQU	LINK_TABLE+$76
LINK_DEVREAD4	EQU	LINK_TABLE+$78
LINK_DEVREAD5	EQU	LINK_TABLE+$7A
LINK_DEVREAD6	EQU	LINK_TABLE+$7C
LINK_DEVREAD7	EQU	LINK_TABLE+$7E
LINK_DEVWRITE	EQU	LINK_TABLE+$80
LINK_DEVWRITE1	EQU	LINK_TABLE+$82
LINK_DEVWRITE2	EQU	LINK_TABLE+$84
LINK_DEVWRITE3	EQU	LINK_TABLE+$86
LINK_DEVWRITE4	EQU	LINK_TABLE+$88
LINK_DEVWRITE5	EQU	LINK_TABLE+$8A
LINK_DEVWRITE6	EQU	LINK_TABLE+$8C
LINK_DEVWRITE7	EQU	LINK_TABLE+$8E
LINK_VMCALL	EQU	LINK_TABLE+$90
LINK_DEVCTRL	EQU	LINK_TABLE+$90
LINK_DEVCTRL1	EQU	LINK_TABLE+$92
LINK_DEVCTRL2	EQU	LINK_TABLE+$94
LINK_DEVCTRL3	EQU	LINK_TABLE+$96
LINK_DEVCTRL4	EQU	LINK_TABLE+$98
LINK_DEVCTRL5	EQU	LINK_TABLE+$9A
LINK_DEVCTRL6	EQU	LINK_TABLE+$9C
LINK_DEVCTRL7	EQU	LINK_TABLE+$9E
LINK_TIMERIRQ	EQU	LINK_TABLE+$A0
LINK_DEVIRQ	EQU	LINK_TABLE+$A0
LINK_DEVIRQ1	EQU	LINK_TABLE+$A2
LINK_DEVIRQ2	EQU	LINK_TABLE+$A4
LINK_DEVIRQ3	EQU	LINK_TABLE+$A6
LINK_DEVIRQ4	EQU	LINK_TABLE+$A8
LINK_DEVIRQ5	EQU	LINK_TABLE+$AA
LINK_DEVIRQ6	EQU	LINK_TABLE+$AC
LINK_DEVIRQ7	EQU	LINK_TABLE+$AE
;
LINK_DUMPSTACK	EQU	LINK_TABLE+$EC
LINK_EXIT	EQU	LINK_TABLE+$EE
;
;**********************************************************
;*
;* LOW-MEMORY DATA TABLES
;*
;**********************************************************
;*
;* SYSTEM FILE IO BUFFER: $0800 - $09FF
;*
SYSFILE_IO_BUFF	EQU	$0800
;*
;* MEMORY HANDLE TABLE
;*
;HMAX	EQU	$0C00
HMAX	EQU	$0200
HTBL_LEN	EQU	HMAX*2
HTBL_END	EQU	$BF00		; MUST BE PAGE BOUNDARY I.E. LSB = $00
HTBL	EQU	HTBL_END-HTBL_LEN
;*
;* STRING POOL DATA HASH TABLE: $0C00 - $0DFF
;*
HSTR_HASHL	EQU	$0C00
HSTR_HASHH	EQU	$0D00
;*
;* CLASS HANDLE TABLE: $0E00 - $0EFF
;*
HCLASS_TBLL	EQU	$0E00
HCLASS_TBLH	EQU	$0E80
;*
;* TYPEAHEAD BUFFER: $0F00 - $0F7F
;*
TYPEBUFFLEN	EQU	$0F00
TYPEBUFF	EQU	$0F01
TYPEBUFFMAX	EQU	$7E
;*
;* THREAD LOCAL STORAGE STACK: $0F80 - $0FFF
;*
TLS	EQU	$0F80
;
;**********************************************************
;*
;* SYSTEM ROUTINES AND LOCATIONS
;*
;**********************************************************
;*
;* MONITOR SPECIAL LOCATIONS AND PRODOS MLI
;*
CSWL	EQU	$36
CSWH	EQU	$37
PROMPTCHAR	EQU	$33
PRODOS	EQU	$BF00
MACHID	EQU	$BF98
;*
;* HARDWARE ADDRESSES
;*
KEYBD	EQU	$C000
CLRKBD	EQU	$C010
SPKR	EQU	$C030
ROMIN	EQU	$C081
LCBNK2	EQU	$C083
LCBNK1	EQU	$C08B
;
;**********************************************************
;*
;* SYSTEM TYPES
;*
;**********************************************************
;*
;* CONSTANT TYPE IDENTIFIERS
;*
CONST_UTF8	EQU	1
CONST_INTEGER	EQU	3
CONST_FLOAT	EQU	4
CONST_LONG	EQU	5
CONST_DOUBLE	EQU	6
CONST_CLASS	EQU	7
CONST_STRING	EQU	8
CONST_FIELDREF	EQU	9
CONST_METHDREF	EQU	10
CONST_IFACEMETHDREF EQU	11
CONST_NAMETYPE	EQU	12
;*
;* DATA TYPE IDENTIFIERS
;*
T_BOOLEAN	EQU	4
T_CHAR	EQU	5
T_FLOAT	EQU	6
T_DOUBLE	EQU	7
T_BYTE	EQU	8
T_SHORT	EQU	9
T_INT	EQU	10
T_LONG	EQU	11
T_ARRAY	EQU	13
T_REF	EQU	14
;*
;* SYSTEM CLASS INDECES
;*
CL_NULL	EQU	0
CL_OBJ	EQU	1
CL_ARRAY	EQU	2
CL_STR	EQU	3
CL_SYS	EQU	3
;*
;* THREAD STATES
;*
S_FREE	EQU	0		; NOT ALLOCATED
S_IDLE	EQU	1		; WAITING TO BE SET TO RUN
S_SUSPEND	EQU	2		; SUSPENDED
S_SLEEP	EQU	3		; SLEEPING
S_BLOCK	EQU	4		; BLOCKED ON OBJECT LOCK
S_WAITNOTIFY	EQU	5		; WAITING FOR NOTIFY
S_WAITIO	EQU	8		; WAIT FOR I/O = 8 + SLOT #
S_RUNNABLE	EQU	16		; WAITING TO RUN
S_RUNNING	EQU	17		; RUNNING
S_INTERRUPTED	EQU	18		; INTERRUPTED
;*
;* DEVICE CONTROL COMMANDS
;*
IOCTL_ID	EQU	1		; IDENTIFY DEVICE
IOCTL_INIT	EQU	2		; INIT DEVICE
IOCTL_ENABLE	EQU	3		; ENABLE DEVICE (INTS ON)
IOCTL_DISABLE	EQU	4		; DISABLE DEVICE (INTS OFF)
IOCTL_AVAIL	EQU	5		; CHARS AVAILABLE
IOCTL_SPACE	EQU	6		; SPACE TO WRITE
IOCTL_INBUFFL	EQU	7		; IN BUFFER ADDRESS LO
IOCTL_INBUFFH	EQU	8		; IN BUFFER ADDRESS HI
IOCTL_INBUFFSZL	EQU	9		; IN BUFFER SIZE LO
IOCTL_INBUFFSZH	EQU	10		; IN BUFFER SIZE HI
IOCTL_OUTBUFFL	EQU	11		; OUT BUFFER ADDRESS LO
IOCTL_OUTBUFFH	EQU	12		; OUT BUFFER ADDRESS HI
IOCTL_OUTBUFFSZL EQU	13		; OUT BUFFER SIZE LO
IOCTL_OUTBUFFSZH EQU	14		; OUT BUFFER SIZE HI
;
; CONSOLE IOCTLS
;
CONCTL_HOME	EQU	16
CONCTL_GOTOXY	EQU	17		; XY LOC IN XY REGS
CONCTL_TEXT80	EQU	20		; SET 80 COLUMN TEXT MODE
;
; MOUSE IOCTLS
;
MOUSECTL_CALLFW	EQU	16		; CALL FW FUNC IN X REG
MOUSECTL_NOIRQ	EQU	17		; UNINSTALL VBL INTERRUPT
;
; SERIAL PORT IOCTLS
;
SERCTL_BAUD	EQU	16
SERCTL_STOPBITS	EQU	17
SERCTL_PARITYBITS EQU	18
SERCTL_DATABITS	EQU	19
SERCTL_XONXOFF	EQU	20